#!/bin/bash
DIR="/tmp/Install"
LANGE_DIR_PATH="/usr/local/share/lang"
QTAPP="Sanitizer.app"
DEST_DIR_APP="/Applications/"
KEXT=$1
RMKEXT="SanDiskCFast.kext"
CURRVERSION=`sw_vers -productVersion`

if [ ! -d /usr/local/share/lang ]
then
	echo "\"/usr/local/share/lang\" not exists!!"
	exit 1
fi
echo Current supporting kext file:${KEXT}

echo "Remove CFast Card If Connected."
echo "Waiting for Card Removal......"
sleep 5

set +e
set -x
        #################################################
        #####-----Installing Qt App -------##### 
	sudo cp -rf ${QTAPP} ${DEST_DIR_APP} 

        #####-----Installing Lang Support -------#####
	sudo cp -rf lang/ ${LANGE_DIR_PATH}
        
	#################################################
        #####-----Installing Back End App -------##### 

        sudo cp -f ${DIR}/UserClientTool /usr/local/bin/
        sudo cp -f ${DIR}/EULA.txt /usr/local/bin/
        sudo cp -f ${DIR}/NOTICE.TXT /usr/local/bin/

    #################################################
        
        #####----- Removing old Kext if at all there  -------##### 
        sudo rm -rf /System/Library/Extensions/${RMKEXT}
        sudo kextunload /System/Library/Extensions/${RMKEXT}
        sudo killall -HUP kextd
        #####----- New Kext Installation  -------##### 
        sudo chown -R root:wheel ${DIR}/${KEXT}
        sudo cp -rf ${DIR}/${KEXT} /System/Library/Extensions/${RMKEXT}

        sudo kextload /System/Library/Extensions/${RMKEXT}
set +x
#       sudo killall -HUP kextd

if [ $CURRVERSION == 10.10 -o $CURRVERSION == 10.10.1 -o $CURRVERSION == 10.10.2 -o $CURRVERSION == 10.10.3 -o $CURRVERSION == 10.10.4 -o $CURRVERSION == 10.10.5 ]
then
        sudo nvram boot-args="debug=0x146 kext-dev-mode=1"
	echo "sudo nvram boot-args=\"debug=0x146 kext-dev-mode=1\"" > ~/.bashrc
        echo "Reboot Is required for Proper Working in $CURRVERSION"
fi
        echo "-------- Sanitizer Installaion Compleated Successfully -------"
