#!/bin/bash
DIR="/tmp/"
CURR=`pwd`
HDIR="${HOME}"
KEXT="SanDiskCFast."
PVERSION=`sw_vers -productVersion`
KEXT_NAME=${KEXT}${PVERSION}."kext"
INSTALL_HOME_DIR="${HOME}/sanitize/"

# Supported OS list
VAR1=10.10
VAR2=10.10.1
VAR3=10.10.2
VAR4=10.10.3
VAR5=10.10.4
VAR6=10.10.5
VAR7=10.11
VAR8=10.11.1
VAR9=10.11.2
VAR10=10.11.3
VAR11=10.11.4
VAR12=10.11.5  # Future Support
VAR13=10.11.6  # Future Support
VAR14=10.11.7  # Future Support
VAR15=10.11.8  # Future Support
VAR16=10.11.9  # Future Support

#set -x 

if [ -d /Applications/Sanitizer.app ]
then
	echo "Sanitizer.app already installed. Do you want to Reinstall it again(y/n)?"
	read usr_input
	if [ $usr_input == 'y' ]
	then
		/usr/local/share/Sanitizer_Uninstaller.sh
	else
		exit
	fi
fi

case $PVERSION in

     "$VAR1")
       echo "GOOD $PVERSION"
       sudo echo "KEXT for $PVERSION Supported">$HDIR/Sanitizer_Installer_log
      ;;
     "$VAR2")
       echo "GOOD $PVERSION"
       sudo echo "KEXT for $PVERSION Supported">$HDIR/Sanitizer_Installer_log
      ;;
     "$VAR3")
       echo "GOOD $PVERSION"
       sudo echo "KEXT for $PVERSION Supported">$HDIR/Sanitizer_Installer_log
      ;;
     "$VAR4")
       echo "GOOD $PVERSION"
       sudo echo "KEXT for $PVERSION Supported">$HDIR/Sanitizer_Installer_log
      ;;
     "$VAR5")
       echo "GOOD $PVERSION"
       sudo echo "KEXT for $PVERSION Supported">$HDIR/Sanitizer_Installer_log
      ;;
     "$VAR6")
       echo "GOOD $PVERSION"
       sudo echo "KEXT for $PVERSION Supported">$HDIR/Sanitizer_Installer_log
      ;;
     "$VAR7")
       echo "GOOD $PVERSION"
       sudo echo "KEXT for $PVERSION Supported">$HDIR/Sanitizer_Installer_log
      ;;
     "$VAR8")
       echo "GOOD $PVERSION"
       sudo echo "KEXT for $PVERSION Supported">$HDIR/Sanitizer_Installer_log
      ;;
     "$VAR9")
       echo "GOOD $PVERSION"
       sudo echo "KEXT for $PVERSION Supported">$HDIR/Sanitizer_Installer_log
      ;;
     "$VAR10")
       echo "GOOD $PVERSION"
       sudo echo "KEXT for $PVERSION Supported">$HDIR/Sanitizer_Installer_log
      ;;
     "$VAR11")
       echo "GOOD $PVERSION"
       sudo echo "KEXT for $PVERSION Supported">$HDIR/Sanitizer_Installer_log
      ;;
     "$VAR12")
       echo "GOOD $PVERSION"
       sudo echo "KEXT for $PVERSION Supported">$HDIR/Sanitizer_Installer_log
      ;;
     "$VAR13")
       echo "GOOD $PVERSION"
       sudo echo "KEXT for $PVERSION Supported">$HDIR/Sanitizer_Installer_log
      ;;
     "$VAR14")
       echo "GOOD $PVERSION"
       sudo echo "KEXT for $PVERSION Supported">$HDIR/Sanitizer_Installer_log
      ;;
     "$VAR15")
       echo "GOOD $PVERSION"
       sudo echo "KEXT for $PVERSION Supported">$HDIR/Sanitizer_Installer_log
      ;;
     "$VAR16")
       echo "GOOD $PVERSION"
       sudo echo "KEXT for $PVERSION Supported">$HDIR/Sanitizer_Installer_log
      ;;
      *)
       sudo echo Current Kext Version is Not Supported in $PVERSION>$HDIR/Sanitizer_Installer_log
       sudo echo "Current Kext Version Not Supported in $PVERSION"
       exit 1
      ;;
esac
echo ${KEXT_NAME}

sudo cp -rf  $CURR/Install_*.tar.gz ${DIR}

[ -d /usr/local/bin ] && echo /usr/local/bin OK || sudo mkdir -p /usr/local/bin
[ -d /usr/local/share/lang ] && echo lang OK || sudo mkdir -p /usr/local/share/lang

cd  $DIR
echo ### Installing Uninstaller in /usr/local/share ###
sudo cp $CURR/CFast_Card_Uninstaller /usr/local/share
sudo cp $CURR/Sanitizer_Uninstaller.sh /usr/local/share
echo Extracting Target Archives.......
sudo tar -zxvf  Install_*.tar.gz 2>> $HDIR/Sanitizer_Installer_log

if [[ $? == 0 ]]
then
	cd Install
	./Install_SanDiskCFast_Sanitize.sh  ${KEXT_NAME}
else
      echo “Package Extraction Unsuccessful”
      exit 1;
fi
sudo rm -f /tmp/Install*.tar.gz
sudo rm -rf /tmp/Install

#set +x
exit 0
